#include <stdio.h>
#include "ConnectionForm.h"
#include "SavedConnection.h"
#include "MainForm.h"

#define kor(str) QString::fromLocal8Bit(str)

// 
ConnectionForm::ConnectionForm()
{
	this->db = 0;
	this->mainForm = 0;
	this->savedConnection = new SavedConnection(10);
	this->SetLayout();
	this->ReadConnectionInFile();
	this->newConnection = 0;

	for(int i=0; i<this->savedConnection->GetLength(); i ++){
		this->storedConnetionCombo->addItem((*(this->savedConnection))[i].GetTitle());
	}
	this->db = new QSqlDatabase(QSqlDatabase::addDatabase("QMYSQL"));
	
	this->SetEachWidget();

	this->stateOfReconnect = false;

	connect(this->storedConnetionCombo, SIGNAL(currentIndexChanged(QString)), this, SLOT(SetEachWidget()));
	connect(this->clearButton, SIGNAL(clicked()), this, SLOT(ClearEachWidget()));
	connect(this->cancelButton, SIGNAL(clicked()), this, SLOT(CancelbuttonClick()));
	connect(this->newButton, SIGNAL(clicked()), this, SLOT(NewConnection()));
	connect(this->okButton, SIGNAL(clicked()), this, SLOT(OkButtonClicked()));
	connect(this->deleteButton, SIGNAL(clicked()), this, SLOT(DeleteButtonClicked()));
	connect(this->saveButton, SIGNAL(clicked()), this, SLOT(SaveConnection()));
}

void ConnectionForm::DeleteButtonClicked()
{
	QString title = this->storedConnetionCombo->currentText();
	
	int ret = this->savedConnection->FindInformationByTitle(title);
	
	Information information;
	
	if( ret != -1){
		
		int messageRet = QMessageBox::warning(this, "Delete", 
			tr("ڽϱ?"), QMessageBox::Ok | QMessageBox::Cancel);
		
		if( messageRet == QMessageBox::Ok){
			
			this->savedConnection->EraseInformation(ret);	//information
			
			this->storedConnetionCombo->clear();
			for(int i=0; i<this->savedConnection->GetLength(); i ++){
				this->storedConnetionCombo->addItem((*(this->savedConnection))[i].GetTitle());
			}
			this->storedConnetionCombo->setCurrentIndex(this->savedConnection->GetLength() - 1);
		}
	}
}


// Ҹ
ConnectionForm::~ConnectionForm()
{
	this->CancelbuttonClick();
	if(this->savedConnection != 0){
		delete this->savedConnection;
	}

	if(this->newConnection != 0){
		delete this->newConnection;		// ׸̼  ... ;;
	}

	DeleteMemory();
}

// â ݾ ̺Ʈ ߻
void ConnectionForm::closeEvent ( QCloseEvent * event )
{
	if(this->stateOfReconnect == false){
		if(this->db != 0){
			this->db->close();
		}
	}
	
	else if(this->stateOfReconnect = true){
		this->mainForm->setEnabled(true);
	}
	
	this->WriteConnectionToFile();
}

// Ű ̺Ʈ ߻ 
void ConnectionForm::keyPressEvent ( QKeyEvent * event )
{
	if( event->key() == Qt::Key_Shift ){
		//this->OkButtonClicked();
	}
}

// Cancel ư Ŭ 
void ConnectionForm::CancelbuttonClick()
{
	this->close();	
}

// ο     
void ConnectionForm::NewConnection()
{
	this->newConnection = new QDialog(this);
	this->newConnection->setWindowTitle("newConnection");
	this->newConnection->resize(200, 100);

	QLineEdit* connectionEdit = new QLineEdit(this->newConnection);
	connectionEdit->setGeometry(QRect(10, 20, 180, 30));
	connectionEdit->setWindowTitle("ConnectionEdit1");

	QPushButton* connectionOkButton = new QPushButton(this->newConnection);
	connectionOkButton->setGeometry(QRect(50, 60, 65, 27));
	connectionOkButton->setWindowTitle("ConnectionOkButton");
	connectionOkButton->setText("OK");

	QPushButton* connectionCancelButton = new QPushButton(this->newConnection);
	connectionCancelButton->setGeometry(QRect(125, 60, 65, 27));
	connectionCancelButton->setWindowTitle("ConnectionCancelButton");
	connectionCancelButton->setText("Cancel");

	connect(connectionOkButton, SIGNAL(clicked()), this, SLOT(NewConnectionOkButtonClick()));
	connect(connectionCancelButton, SIGNAL(clicked()), this->newConnection, SLOT(close()));
	
	this->newConnection->exec();
}

// ο     
void ConnectionForm::SaveConnection()
{
	QString title = this->storedConnetionCombo->currentText();
	
	int ret = this->savedConnection->FindInformationByTitle(title);
	
	Information information;
	
	if( this->GetInformationInEachWidget(information, title) != -1){
		
		if( ret == -1){
			
			this->savedConnection->RecordInformation(information);	//information
			
			this->storedConnetionCombo->clear();
			for(int i=0; i<this->savedConnection->GetLength(); i ++){
				this->storedConnetionCombo->addItem((*(this->savedConnection))[i].GetTitle());
			}
			this->storedConnetionCombo->setCurrentIndex(this->savedConnection->GetLength() - 1);
		}
		
		else{
			int messageRet = QMessageBox::warning(this, "Overwrite", 
				tr(" ڽϱ?"), QMessageBox::Ok | QMessageBox::Cancel);
			
			if( messageRet == QMessageBox::Ok){
				int index = this->savedConnection->FindInformationByTitle(title);
				
				Information information;
				if( this->GetInformationInEachWidget(information, title) != -1){
					this->savedConnection->CorrectInformation(index, information);
					
					this->storedConnetionCombo->clear();
					for(int i=0; i<this->savedConnection->GetLength(); i ++){
						this->storedConnetionCombo->addItem((*(this->savedConnection))[i].GetTitle());
					}		
					this->storedConnetionCombo->setCurrentIndex(index);
				}
			}
		}
	}

	else{
		QMessageBox::warning(this, "Input value", tr(" Էּ"), QMessageBox::Ok);
	}
}

// Ok ư Ŭ  
void ConnectionForm::OkButtonClicked()
{
	Information information;
	QString title = this->storedConnetionCombo->currentText();

	if( this->GetInformationInEachWidget(information, title) != -1){

		this->db->setHostName(information.GetHostAddress());
		this->db->setDatabaseName(information.GetDatabase()+"\0");
		this->db->setUserName(information.GetUserName()+"\0");
		this->db->setPort(information.GetPort().toInt());
		this->db->setPassword(information.GetPassword()+"\0");
		
		if( this->db != 0 ){
			this->db->close();
		}

		bool ok = db->open();

		if( ok == true ){
			if( this->mainForm == 0){
				this->mainForm = new MainForm(this);
			}
			else{
				this->mainForm->NewSetting();
			}
			this->mainForm->show();
			this->setVisible(false);
		}
		else{
			QMessageBox::warning(this, "Wrong Values", tr("  ϴ."), QMessageBox::Ok);
		}
	}

	else{
			QMessageBox::warning(this, "Input value", tr(" Էּ"), QMessageBox::Ok);
	}
}

//  Widget   о
int ConnectionForm::GetInformationInEachWidget(Information& information, QString& title)
{
	int ret = -1;

	QString hostAddress = this->serverHostEdit->text();
	QString userName = this->userNameEdit->text();
	QString password = this->passwordEdit->text();
	QString port = this->portEdit->text();
	QString database = this->databaseEdit->text();

	if ( hostAddress.isEmpty() == 0 &&  userName.isEmpty() == 0 && password.isEmpty() == 0 &&
		 port.isEmpty() == 0 && database.isEmpty() == 0 ){

		ret = 0;
	}

	information = Information(title, hostAddress, userName, password, port, database);

	return ret;
}

// NewConnection Dialog OK ư Ŭ  
void ConnectionForm::NewConnectionOkButtonClick()
{
	QWidget* name = this->newConnection->childAt(10, 20);
	QString title(((QLineEdit*)name)->text());

	if( title != "" ){
			int ret = this->savedConnection->FindInformationByTitle(title);

			if( ret == -1){
				this->storedConnetionCombo->addItem(title);
				this->storedConnetionCombo->setCurrentIndex(this->storedConnetionCombo->count() - 1);
				this->newConnection->close();
			}

			else{
				QMessageBox::warning(this, "Existed Name", tr("ϴ ̸Դϴ."), QMessageBox::Ok);
			}
	}
	
	else{
		QMessageBox::warning(this, "Input name", tr("̸ Էּ."), QMessageBox::Ok);
	}
}

//   Ͽ о 
void ConnectionForm::ReadConnectionInFile()
{
	FILE* file = 0;
	int length = 0;
	char titleC[32] = {' ', };
	char hostAddressC[32] = {' ', };
	char userNameC[32] = {' ', };
	char passwordC[32] = {' ', };
	char portC[32] = {' ', };
	char databaseC[32] = {' ', };
	
	file = fopen("SavedConnection.txt", "rt");

	char buffer[8] = {' ', };
	fgets(buffer, 8, file);

	if(strcmp(buffer, "") != 0){
		length = atoi(buffer);

		for(int i=0; i<length; i++){
			fgets(titleC, 32, file);
			fgets(hostAddressC, 32, file);
			fgets(userNameC, 32, file);
			fgets(passwordC, 32, file);
			fgets(portC, 32, file);
			fgets(databaseC, 32, file);

			QString title(titleC);
			title.remove(QChar('\n'), Qt::CaseInsensitive);
			QString hostAddress(hostAddressC);
			hostAddress.remove(QChar('\n'), Qt::CaseInsensitive);
			QString userName(userNameC);
			userName.remove(QChar('\n'), Qt::CaseInsensitive);
			QString password(passwordC);
			password.remove(QChar('\n'), Qt::CaseInsensitive);
			QString port(portC);
			port.remove(QChar('\n'), Qt::CaseInsensitive);
			QString database(databaseC);
			database.remove(QChar('\n'), Qt::CaseInsensitive);

			Information information(title, hostAddress, userName, password, port, database);
			this->savedConnection->RecordInformation(information);
		}
	}
}

//   Ͽ 
void ConnectionForm::WriteConnectionToFile()
{
	FILE* file = 0;

	file = fopen("SavedConnection.txt", "wt");

	if( file != 0 ){
		int number = this->savedConnection->GetLength();
		fprintf(file, "%d\n", number);

		for(int i=0; i<savedConnection->GetLength(); i++){
			fprintf(file, "%s\n", (*savedConnection)[i].GetTitle().toStdString().c_str());
			fprintf(file, "%s\n", (*savedConnection)[i].GetHostAddress().toStdString().c_str());
			fprintf(file, "%s\n", (*savedConnection)[i].GetUserName().toStdString().c_str());
			fprintf(file, "%s\n", (*savedConnection)[i].GetPassword().toStdString().c_str());
			fprintf(file, "%s\n", (*savedConnection)[i].GetPort().toStdString().c_str());
			fprintf(file, "%s\n", (*savedConnection)[i].GetDatabase().toStdString().c_str());
		}

		fclose(file);
	}
}

//  Widget  
void ConnectionForm::SetEachWidget()
{
	QString title;
	title.clear();
	title = this->storedConnetionCombo->currentText();
	int index = this->savedConnection->FindInformationByTitle(title);

	if( index != -1){
		this->ClearEachWidget();
		this->serverHostEdit->insert((*(this->savedConnection))[index].GetHostAddress());
		this->userNameEdit->insert((*(this->savedConnection))[index].GetUserName());
		this->databaseEdit->insert((*(this->savedConnection))[index].GetDatabase());
		this->portEdit->insert((*(this->savedConnection))[index].GetPort());
		
		// Password ...
		this->passwordEdit->insert((*(this->savedConnection))[index].GetPassword());
	}
}

//  Widget ʱȭ 
void ConnectionForm::ClearEachWidget()
{
	this->passwordEdit->clear();
	this->serverHostEdit->clear();
	this->userNameEdit->clear();
	this->databaseEdit->clear();
	this->portEdit->clear();
}

// Layout  
void ConnectionForm::SetLayout()
{
	this->setWindowTitle (QApplication::translate("ConnectionForm", "ConnectionForm", 0, QApplication::UnicodeUTF8));
	this->resize(400, 375);

	this->cancelButton = new QPushButton(this);
	this->cancelButton->setGeometry(QRect(300, 340, 80, 27));
	this->cancelButton->setText(QApplication::translate("ConnectionForm", "Cancel", 0, QApplication::UnicodeUTF8));

	this->clearButton = new QPushButton(this);
	this->clearButton->setGeometry(QRect(200, 340, 80, 27));
	this->clearButton->setText("Clear");

	this->okButton = new QPushButton(this);
	this->okButton->setGeometry(QRect(100, 340, 80, 27));
	this->okButton->setText("OK");

	this->newButton = new QPushButton(this);
	this->newButton->setGeometry(QRect(20, 20, 101, 27));
	this->newButton->setText("New");

	this->saveButton = new QPushButton(this);
	this->saveButton->setGeometry(QRect(151, 20, 101, 27));
	this->saveButton->setText("Save");

	this->deleteButton = new QPushButton(this);
	this->deleteButton->setGeometry(QRect(277, 20, 101, 27));
	this->deleteButton->setText("Delete");

	this->connectGroup = new QGroupBox(this);
	this->connectGroup->setGeometry(QRect(22, 107, 361, 221));
	this->connectGroup->setTitle("Connect to MySQL Server");

	this->storedConnectionLabel = new QLabel(this);
	this->storedConnectionLabel->setGeometry(QRect(20, 70, 124, 18));
	this->storedConnectionLabel->setText("Stored Connection : ");

	this->serverHostLabel = new QLabel(this->connectGroup);
	this->serverHostLabel->setGeometry(QRect(20, 34, 85, 18));
	this->serverHostLabel->setText("Server Host : ");

	this->userNameLabel = new QLabel(this->connectGroup);
	this->userNameLabel->setGeometry(QRect(20, 70, 74, 18));
	this->userNameLabel->setText("User Name : ");

	this->passwordLabel = new QLabel(this->connectGroup);
	this->passwordLabel->setGeometry(QRect(20, 106, 69, 18));
	this->passwordLabel->setText("Password : ");

	this->databaseLabel = new QLabel(this->connectGroup);
	this->databaseLabel->setGeometry(QRect(20, 176, 69, 18));
	this->databaseLabel->setText("Database : ");

	this->storedConnetionCombo = new QComboBox(this);
	this->storedConnetionCombo->setGeometry(QRect(146, 67, 211, 26));

	this->storedConnectionButton = new QToolButton(this);
	this->storedConnectionButton->setGeometry(QRect(360, 69, 24, 23));
	this->storedConnectionButton->setText("...");

	this->serverHostEdit = new QLineEdit(this->connectGroup);
	this->serverHostEdit->setGeometry(QRect(110, 30, 241, 27));

	this->userNameEdit = new QLineEdit(this->connectGroup);
	this->userNameEdit->setGeometry(QRect(110, 66, 241, 27));

	this->passwordEdit = new QLineEdit(this->connectGroup);
	this->passwordEdit->setGeometry(QRect(110, 102, 121, 27));
	this->passwordEdit->setEchoMode(QLineEdit::Password);

	this->databaseEdit = new QLineEdit(this->connectGroup);
	this->databaseEdit->setGeometry(QRect(110, 172, 241, 27));

	this->portEdit = new QLineEdit(this->connectGroup);
	this->portEdit->setGeometry(QRect(110, 136, 121, 27));

	this->portLabel = new QLabel(this->connectGroup);
	this->portLabel->setGeometry(QRect(20, 140, 35, 18));
	this->portLabel->setText("Port : ");
}

// Ҵ ޸𸮸 
void ConnectionForm::DeleteMemory()
{
	if( this->cancelButton != 0){
		delete this->cancelButton;
	}

	if( this->clearButton != 0){
		delete this->clearButton;
	}

	if( this->okButton != 0){
		delete this->okButton;
	}

	if( this->newButton != 0){
		delete this->newButton;
	}

	if( this->saveButton != 0){
		delete this->saveButton;
	}

	if( this->deleteButton != 0 ){
		delete this->deleteButton;
	}

	if( this->connectGroup != 0){
		delete this->connectGroup;
	}

	if( this->storedConnectionLabel != 0){
		delete this->storedConnectionLabel;
	}

	if( this->serverHostLabel != 0){
		delete this->serverHostLabel;
	}

	if( this->userNameLabel != 0){
		delete this->userNameLabel;
	}

	if( this->passwordLabel != 0){
		delete this->passwordLabel;
	}

	if( this->databaseLabel != 0){
		delete this->databaseLabel;
	}

	if( this->storedConnetionCombo != 0){
		delete this->storedConnetionCombo;
	}

	if( this->storedConnectionButton != 0){
		delete this->storedConnectionButton;
	}

	if( this->serverHostEdit != 0){
		delete this->serverHostEdit;
	}

	if( this->userNameEdit != 0){
		delete this->userNameEdit;
	}

	if( this->passwordEdit != 0){
		delete this->passwordEdit;
	}

	if( this->databaseEdit != 0){
		delete this->databaseEdit;
	}

	if( this->portEdit != 0){
		delete this->portEdit;
	}

	if( this->portLabel != 0){
		delete this->portLabel;
	}

	if( this->db != 0){
		delete this->db;
	}

	if(this->mainForm != 0){
		delete this->mainForm;
	}
}
